"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loginSchema = exports.userSchema = void 0;
const zod_1 = require("zod");
exports.userSchema = zod_1.z.object({
    fullName: zod_1.z
        .string()
        .min(1, "Full name is required.")
        .max(100, "Full name must be at most 100 characters."),
    email: zod_1.z
        .string()
        .email("Invalid email format.")
        .max(100, "Email must be at most 100 characters."),
    phone: zod_1.z
        .string()
        .min(5, "Phone number must be at least 5 digits.")
        .max(20, "Phone number must be at most 20 digits."),
    password: zod_1.z.string().min(6, "Password must be at least 6 characters."),
    emailVerified: zod_1.z.enum(["yes", "no"]).optional(),
    phoneVerified: zod_1.z.enum(["yes", "no"]).optional(),
    createdAt: zod_1.z.string().datetime().optional(),
    updatedAt: zod_1.z.string().datetime().optional(),
});
exports.loginSchema = zod_1.z.object({
    email: zod_1.z
        .string()
        .email("Invalid email format.")
        .max(100, "Email must be at most 100 characters."),
    password: zod_1.z.string().min(6, "Password must be at least 6 characters."),
});
