"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateMode = void 0;
const responseHelper_1 = require("./responseHelper");
/**
 * Validates the request mode.
 * @param res - Express Response object
 * @param mode - The mode from request body
 * @param validModes - Array of allowed modes
 * @returns {boolean} - Returns true if the mode is valid, otherwise sends a response and returns false.
 */
const validateMode = (res, mode, validModes) => {
    if (!validModes.includes(mode)) {
        (0, responseHelper_1.sendResponse)(res, 400, false, `Invalid mode. Allowed modes: ${validModes.join(", ")}.`);
        return false;
    }
    return true;
};
exports.validateMode = validateMode;
