"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const controllers_1 = require("../controllers");
const authMiddleware_1 = require("../middleware/authMiddleware");
const router = express_1.default.Router();
// ✅ Public Routes (No Auth Required)
router.post("/login", controllers_1.loginUserController);
router.post("/logout", controllers_1.logoutController);
// ✅ Protected Routes (Require authentication)
router.post("/users/register", controllers_1.handleUserRequest);
router.post("/users", authMiddleware_1.authMiddleware, controllers_1.handleUserRequest);
exports.default = router;
