"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authMiddleware = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const constant_1 = require("../constant/constant");
const authMiddleware = (req, res, next) => {
    const authHeader = req.headers.authorization; // ✅ Extract token from headers
    if (!authHeader || !authHeader.startsWith("Bearer ")) {
        res.status(401).json({
            success: false,
            message: "Unauthorized: No token provided",
        });
        return;
    }
    const token = authHeader.split(" ")[1]; // ✅ Extract actual token
    try {
        const decoded = jsonwebtoken_1.default.verify(token, constant_1.JWT_SECRET);
        req.user = decoded; // ✅ Attach decoded user info to request
        next();
    }
    catch (error) {
        res.status(403).json({
            success: false,
            message: "Forbidden: Invalid or expired token",
        });
    }
};
exports.authMiddleware = authMiddleware;
