"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.users = void 0;
const drizzle_orm_1 = require("drizzle-orm");
const mysql_core_1 = require("drizzle-orm/mysql-core");
exports.users = (0, mysql_core_1.mysqlTable)("users", {
    id: (0, mysql_core_1.serial)("id").primaryKey(),
    fullName: (0, mysql_core_1.varchar)("full_name", { length: 100 }).notNull(),
    email: (0, mysql_core_1.varchar)("email", { length: 100 }).notNull(),
    phone: (0, mysql_core_1.varchar)("phone", { length: 20 }).notNull(),
    passwordHash: (0, mysql_core_1.varchar)("password_hash", { length: 255 }).notNull(),
    emailVerified: (0, mysql_core_1.varchar)("email_verified", { length: 5 }).notNull().default("no"),
    phoneVerified: (0, mysql_core_1.varchar)("phone_verified", { length: 5 }).notNull().default("no"),
    // ✅ Use raw SQL for CURRENT_TIMESTAMP
    createdAt: (0, mysql_core_1.timestamp)("created_at").default((0, drizzle_orm_1.sql) `CURRENT_TIMESTAMP`),
    updatedAt: (0, mysql_core_1.timestamp)("updated_at").default((0, drizzle_orm_1.sql) `CURRENT_TIMESTAMP`),
}, (table) => ({
    idxEmail: (0, mysql_core_1.index)("idx_users_email").on(table.email),
    idxPhone: (0, mysql_core_1.index)("idx_users_phone").on(table.phone),
    idxCreatedAt: (0, mysql_core_1.index)("idx_users_created_at").on(table.createdAt),
}));
