"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const dotenv_1 = __importDefault(require("dotenv"));
const helmet_1 = __importDefault(require("helmet"));
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const express_rate_limit_1 = __importDefault(require("express-rate-limit"));
const compression_1 = __importDefault(require("compression"));
const route_1 = __importDefault(require("./src/routes/route"));
dotenv_1.default.config();
const app = (0, express_1.default)();
const port = process.env.PORT || 5000;
// ✅ Sync Offline Data on Startup
app.set('trust proxy', 1);
// Rate limiter 
const limiter = (0, express_rate_limit_1.default)({
    windowMs: 15 * 60 * 1000, // 15 minutes
    max: 100, // Limit each IP to 100 requests per window
});
// CORS configuration
const corsOptions = {
    origin: [
        'http://localhost:3000',
    ],
    methods: ['GET', 'POST'],
    allowedHeaders: [
        'Authorization',
        'X-User-Role',
        'Content-Type',
    ],
};
// app.use(morganMiddleware);
app.use((0, cors_1.default)(corsOptions));
app.use((0, cookie_parser_1.default)());
app.use(express_1.default.json());
app.use((0, helmet_1.default)());
app.use(limiter);
app.use((0, compression_1.default)());
app.use('/api/v1', route_1.default);
app.get('/', (req, res) => {
    res.status(200).send('OK');
});
app.listen(port, () => {
    console.log(`Server is running at http://localhost:${port}`);
});
exports.default = app;
